package app.firezone.synk.network.Activities;

import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;

import android.app.Dialog;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.os.Bundle;
import android.widget.Toast;


import com.squareup.picasso.Picasso;

import app.firezone.synk.network.API.APIClient;
import app.firezone.synk.network.API.MyApi;
import app.firezone.synk.network.API.SharedPrefManager;
import app.firezone.synk.network.Adapter.LeaderboardAdapter;
import app.firezone.synk.network.R;
import app.firezone.synk.network.databinding.ActivitySubjectBinding;
import app.firezone.synk.network.model.User;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

import java.util.ArrayList;
import java.util.List;

public class ScoreActivity extends AppCompatActivity {

    ActivitySubjectBinding binding;

    ArrayList<User> list;
    LeaderboardAdapter adapter;

    private MyApi myApi;
    Dialog dialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        binding = ActivitySubjectBinding.inflate(getLayoutInflater());
        setContentView(binding.getRoot());

        binding.backArrow.setOnClickListener(v -> finish());
        long userId = SharedPrefManager.getInstance(ScoreActivity.this).getUserId();
        myApi = APIClient.getApiClient(ScoreActivity.this).create(MyApi.class);

        list = new ArrayList<>();
        dialog = new Dialog(ScoreActivity.this);
        dialog.setContentView(R.layout.loading_dialog);

        if (dialog.getWindow() != null) {
            dialog.getWindow().setBackgroundDrawable(new ColorDrawable(Color.TRANSPARENT));
            dialog.setCancelable(true);
        }

        dialog.show();

        // RecyclerView setup
        LinearLayoutManager layoutManager = new LinearLayoutManager(ScoreActivity.this);
        binding.recyclerViewLeaderboard.setLayoutManager(layoutManager);

        adapter = new LeaderboardAdapter(list, ScoreActivity.this);
        binding.recyclerViewLeaderboard.setAdapter(adapter);

        Call<List<User>> calls = myApi.getUsersOrderedByEarning();
        calls.enqueue(new Callback<List<User>>() {
            @Override
            public void onResponse(Call<List<User>> call, Response<List<User>> response) {
                if (response.isSuccessful() && response.body() != null) {
                    List<User> userList = response.body();
                    if (!userList.isEmpty()) {

                        setTopThreeUsers(userList);

                        int endIndex = Math.min(userList.size(), 100); // 3 top users + 100 others = 103 total
                        List<User> remainingUsers = userList.size() > 3 ? userList.subList(3, endIndex) : new ArrayList<>();
                        list.clear();
                        list.addAll(remainingUsers);
                        adapter.notifyDataSetChanged();

                        dialog.dismiss();
                    } else {
                        dialog.dismiss();
                        Toast.makeText(ScoreActivity.this, "No users found", Toast.LENGTH_SHORT).show();
                    }
                } else {
                    dialog.dismiss();
                    Toast.makeText(ScoreActivity.this, "Failed to fetch users", Toast.LENGTH_SHORT).show();
                }
            }

            @Override
            public void onFailure(Call<List<User>> call, Throwable t) {
                dialog.dismiss();
                Toast.makeText(ScoreActivity.this, "Error: " + t.getMessage(), Toast.LENGTH_SHORT).show();
            }
        });
    }

    private void setTopThreeUsers(List<User> users) {
        if (users.size() >= 1) {
            User user1 = users.get(0);
            binding.top1Name.setText(user1.getName());
            binding.top1Amount.setText("₹" + formatAmount(user1.getTotalEarning()));
            Picasso.get().load(user1.getProfile()).placeholder(R.drawable.new_users).into(binding.top1Image);
        }

        if (users.size() >= 2) {
            User user2 = users.get(1);
            binding.top2Name.setText(user2.getName());
            binding.top2Amount.setText("₹" + formatAmount(user2.getTotalEarning()));
            Picasso.get().load(user2.getProfile()).placeholder(R.drawable.new_users).into(binding.top2Image);
        }

        if (users.size() >= 3) {
            User user3 = users.get(2);
            binding.top3Name.setText(user3.getName());
            binding.top3Amount.setText("₹" + formatAmount(user3.getTotalEarning()));
            Picasso.get().load(user3.getProfile()).placeholder(R.drawable.new_users).into(binding.top3Image);
        }
    }

    private String formatAmount(double amount) {
        if (amount >= 100000) {
            return String.format("%.2fL", amount / 100000.0);
        } else if (amount >= 1000) {
            return String.format("%.2fK", amount / 1000.0);
        } else {
            return String.format("%.2f", amount);
        }
    }
}